/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.user;

import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import com.ibm.websm.property.WPropertyComponent;
import com.ibm.websm.property.WPropertyEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UserWPropertyList
extends JPanel
implements WPropertyComponent,
ListSelectionListener {
    public static final int READ_ONLY = 1;
    public static final int EDIT = 2;
    public String _final_value = "";
    private WPropertyEditor _editor;
    private int _mode;
    private JList _list;
    private DefaultListModel _listModel;
    private JScrollPane _js;
    private Color _background;
    private Color _selectedBackground;
    private Color _foreground;
    private Color _selectedForeground;

    public UserWPropertyList(WPropertyEditor wPropertyEditor, int n) {
        this._editor = wPropertyEditor;
        this._mode = n;
        this.setOpaque(true);
        this._listModel = new DefaultListModel();
        this._list = new JList(this._listModel);
        this._list.setSelectionMode(2);
        this._js = new JScrollPane(this._list);
        this.setLayout(new BorderLayout());
        this.add((Component)this._js, "Center");
        String[] stringArray = this._editor.getTags();
        Object var4_4 = null;
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this._listModel.addElement(stringArray[i]);
            }
        } else {
            this._mode = 1;
            String string = this._editor.getAsText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String[] stringArray2 = new String[100];
        }
        this._list.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (IDebug.enabled) {
            IDebug.println((String)"In valueChanged...");
        }
        if (this._mode == 1) {
            return;
        }
        String string = "";
        Object[] objectArray = this._list.getSelectedValues();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = (String)objectArray[i];
            if (IDebug.enabled) {
                IDebug.println((String)("selVal : " + string2));
            }
            string = i != 0 ? string + "," + string2 : string2;
        }
        String string3 = (String)this._editor.getValue();
        this._final_value = string;
        if (string3 != null && !string.equals(string3)) {
            if (IDebug.enabled) {
                IDebug.println((String)("Set As Text :" + string));
            }
            this._editor.setAsText(string);
        }
    }

    public void reset(WPropertyEditor wPropertyEditor) {
        this._list.clearSelection();
    }

    public void enterContextHelpMode() {
    }

    public void exitContextHelpMode() {
    }

    public Component getComponent() {
        return this;
    }

    public void setValue(Object object, boolean bl, boolean bl2, int n) {
    }

    public void setFont(Font font) {
        super.setFont(font);
    }

    public void setColor(Color color, Color color2, Color color3, Color color4) {
        this._background = color;
        this._foreground = color2;
        this._selectedBackground = color3;
        this._selectedForeground = color4;
        super.setBackground(this._background);
        super.setForeground(this._foreground);
    }

    public void updateValue(WPropertyEditor wPropertyEditor) {
        if (this._editor == null) {
            return;
        }
        if (this._mode == 1) {
            return;
        }
        boolean bl = true;
        String string = (String)this._editor.getValue();
        String[] stringArray = null;
        if (IDebug.enabled) {
            IDebug.println((String)("Update Value : " + string));
        }
        try {
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = "";
                    if (bl) {
                        string2 = stringTokenizer.nextToken();
                        stringArray = this.setSelectedRoles(string2);
                        bl = false;
                        continue;
                    }
                    string2 = stringTokenizer.nextToken();
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n;
                        if (!string2.equals(stringArray[i]) || this._list.isSelectedIndex(n = this._listModel.indexOf(string2))) continue;
                        this._list.addSelectionInterval(n, n);
                    }
                }
                int n = this._list.getSelectedIndex();
                this._list.ensureIndexIsVisible(n);
            } else {
                this._list.clearSelection();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public String[] setSelectedRoles(String string) {
        try {
            String[] stringArray = null;
            EExecResult eExecResult = EExec.Exec((String)("grep -w " + string + " /etc/group |cut -f 1 -d:"));
            if (IDebug.enabled) {
                IDebug.println((String)("rc=" + eExecResult.rc + ",stdout=" + eExecResult.stdout + ",stderr=" + eExecResult.stderr));
            }
            if (eExecResult.stdout != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(eExecResult.stdout, "\n");
                int n = 0;
                if (stringTokenizer.countTokens() > 0) {
                    stringArray = new String[stringTokenizer.countTokens()];
                }
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n] = stringTokenizer.nextToken();
                    ++n;
                }
                return stringArray;
            }
            return null;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return null;
        }
    }

    public void saveValueToEditor(WPropertyEditor wPropertyEditor) {
        wPropertyEditor.setValue((Object)this._final_value);
    }

    public JList getList() {
        return this._list;
    }
}

